#!/bin/sh
#
# This script passes the correct include_path to the Inform6 compiler
# for building games using the PunyInform Library.  Normally this script
# is automatically configured by the installing Makefile.
#
# This script was written by David Griffith <dave@661.org> in 2021 and
# released to the public domain.

# This is where the Inform6 libraries are expected to be installed.
# The installation process will fix this variable.
LIBPATH=./

# Note to self: Update this when making a new release.
SCRIPTVERSION=6.44-r3

INFORM=inform
LIB=punyinform
LIBNAME="PunyInform"
NEWPATH=$LIBPATH/$LIB/lib
PUNY_GLOBALS=$NEWPATH/globals.h
ZM_VERSION=-v3

MYNAME=`basename $0 ".sh"`

PUNYINFORM_MAJOR=`grep PUNYINFORM_MAJOR_VERSION $PUNY_GLOBALS | sed s/\;//g | cut -d " " -f4`
PUNYINFORM_MINOR=`grep PUNYINFORM_MINOR_VERSION $PUNY_GLOBALS | sed s/\;//g | cut -d " " -f4`
PUNYINFORM_PATCH=`grep PUNYINFORM_PATCH_VERSION $PUNY_GLOBALS | sed s/\;//g | cut -d " " -f4`

if [ $PUNYINFORM_PATCH -gt 0 ] ; then
	LIBVERSION="$PUNYINFORM_MAJOR.$PUNYINFORM_MINOR.$PUNYINFORM_PATCH"
else
	LIBVERSION="$PUNYINFORM_MAJOR.$PUNYINFORM_MINOR"
fi

echo "Inform 6 Library Selection Wrapper by David Griffith."
echo "From version $SCRIPTVERSION of the Inform 6 for Unix package."

if [ "$MYNAME" != "$LIB" ] ; then
	VERSIONSTRING=`echo $MYNAME | sed s/$LIB//g`
	VERSION=`echo $VERSIONSTRING | sed s/^-//g`
	INFORM=$INFORM$VERSIONSTRING
else
	VERSION=`$INFORM -V | cut -d " " -f2`
fi

echo "Using Inform version $VERSION."
echo "Using $LIBNAME library version $LIBVERSION."
echo "====================================================="

for ARG in "$@"; do
	case $ARG
	in
		-v*)
			ZM_VERSION=$ARG
			break
		;;
	esac
done

for ARG in "$@"; do
	if [ "$ZM_VERSION" != "$ARG" ] ; then
		LINE="$LINE $ARG"
	fi
done

FINAL="$ZM_VERSION --define PUNYINFORM=1 +$NEWPATH $LINE"
$INFORM $FINAL
